<?php 

include('includes/config.php');


?>


<?php
include('includes/user_data.php');

?>
<?php


$teacher_id = $_SESSION['teacher_id'] ?? null;
if (!$teacher_id) {
    echo "You must be logged in as a teacher.";
    exit;
}

// Load dropdown data
$sessions = $dbh->query("SELECT id, session_year FROM sessions ORDER BY session_year DESC")->fetchAll(PDO::FETCH_ASSOC);
$terms    = $dbh->query("SELECT id, term_name FROM terms ORDER BY id")->fetchAll(PDO::FETCH_ASSOC);
$classes  = $dbh->query("SELECT id, name FROM classes ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
$subjects = $dbh->query("SELECT id, name FROM Subjects ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
?>


<!doctype html>
<html lang="en">


<!-- Mirrored from codervent.com/rocker/demo/vertical/user-profile.html by HTTrack Website Copier/3.x [XR&CO'2014], Fri, 26 Aug 2022 06:47:36 GMT -->
<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!--favicon-->
	<link rel="icon" href="assets/images/favicon-32x32.png" type="image/png" />
	<!--plugins-->
	<link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
	<link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
	<link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
	<!-- loader-->
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
	<!-- Bootstrap CSS -->
	<link href="assets/css/bootstrap.min.css" rel="stylesheet">
	<link href="assets/css/bootstrap-extended.css" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&amp;display=swap" rel="stylesheet">
	<link href="assets/css/app.css" rel="stylesheet">
	<link href="assets/css/icons.css" rel="stylesheet">
	<!-- Theme Style CSS -->
	<link rel="stylesheet" href="assets/css/dark-theme.css" />
	<link rel="stylesheet" href="assets/css/semi-dark.css" />
	<link rel="stylesheet" href="assets/css/header-colors.css" />

  <title>Question Manager</title>
   <script src="https://cdn.tailwindcss.com"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

</head>
<body>
	<!--wrapper-->
	<div class="wrapper">
		<!--sidebar wrapper -->
		<?php include 'includes/side.php'; ?>
		<!--end sidebar wrapper -->
		<!--start header -->
		<?php include 'includes/head.php'; ?>
		<!--end header -->
		<!--start page wrapper -->
		<div class="page-wrapper">
			<div class="page-content">
				<!--breadcrumb-->
				<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
					<div class="breadcrumb-title pe-3"></div>
					<div class="ps-3">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb mb-0 p-0">
								<li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
								</li>
								<li class="breadcrumb-item active" aria-current="page"></li>
							</ol>
						</nav>
					</div>
					
				</div>
				<!--end breadcrumb-->
				<div class="container">
					<div class="main-body">
						<div class="row">
						
							<div class="col-lg-12">
								<div class="card">
									<div class="card-body">




  <div class="max-w-7xl mx-auto bg-white shadow-md rounded-xl p-6">
    <h1 class="text-2xl font-bold mb-4">Manage Questions</h1>

    <!-- Filters -->
    <div class="grid grid-cols-2 md:grid-cols-5 gap-4 mb-4">
      <select id="session" class="border p-2 rounded">
        <option value="">Select Session</option>
        <?php foreach($sessions as $s): ?>
          <option value="<?=$s['id']?>"><?=$s['session_year']?></option>
        <?php endforeach; ?>
      </select>

      <select id="term" class="border p-2 rounded">
        <option value="">Select Term</option>
        <?php foreach($terms as $t): ?>
          <option value="<?=$t['id']?>"><?=$t['term_name']?></option>
        <?php endforeach; ?>
      </select>

      <select id="class" class="border p-2 rounded">
        <option value="">Select Class</option>
        <?php foreach($classes as $c): ?>
          <option value="<?=$c['id']?>"><?=$c['name']?></option>
        <?php endforeach; ?>
      </select>

      <select id="subject" class="border p-2 rounded">
        <option value="">Select Subject</option>
        <?php foreach($subjects as $sb): ?>
          <option value="<?=$sb['id']?>"><?=$sb['name']?></option>
        <?php endforeach; ?>
      </select>

      <select id="type" class="border p-2 rounded">
        <option value="">Question Type</option>
        <option value="objective">Objective</option>
        <option value="fill">Fill in the Blanks</option>
        <option value="theory">Theory</option>
      </select>
    </div>

    <!-- Set Time -->
    <div class="mb-6">
      <input type="number" id="set_time" placeholder="Set Time (minutes)" class="border p-2 rounded w-1/2">
    </div>

    <!-- Question Form -->
    <form id="questionsForm">
      <div id="questionsContainer" class="space-y-6"></div>
      <div class="mt-4">
        <button type="button" id="addMore" class="bg-blue-600 text-white px-4 py-2 rounded">+ Add More Question</button>
        <button type="submit" class="bg-green-600 text-white px-4 py-2 rounded ml-2">Save Questions</button>
      </div>
    </form>

    <!-- Status -->
    <div id="msg" class="mt-4 text-center font-semibold"></div>

    <!-- Existing Questions -->
    <div id="existingQuestions" class="mt-10">
      <h2 class="text-xl font-semibold mb-3">Existing Questions</h2>
      <div id="questionsTable" class="overflow-x-auto"></div>
    </div>
  </div>

<script>
$(document).ready(function(){
  // Add first question block on load
  addQuestionBlock();

  // Add more button
  $("#addMore").click(function(){
    addQuestionBlock();
  });

  // Add new block
  function addQuestionBlock(){
    let block = `
      <div class="p-4 border rounded-lg bg-gray-50 question-block">
        <textarea name="question_text[]" placeholder="Enter Question" class="w-full border p-2 rounded mb-2"></textarea>
        <div class="objective-fields hidden">
          <input type="text" name="options[]" placeholder="Enter options separated by commas" class="w-full border p-2 rounded mb-2">
          <input type="text" name="correct_answer[]" placeholder="Correct Answer" class="w-full border p-2 rounded mb-2">
        </div>
        <div class="fill-fields hidden">
          <input type="text" name="correct_answer_fill[]" placeholder="Correct Answer" class="w-full border p-2 rounded">
        </div>
        <div class="theory-fields hidden">
          <textarea name="theory_answer[]" placeholder="Expected Answer (optional)" class="w-full border p-2 rounded"></textarea>
        </div>
      </div>`;
    $("#questionsContainer").append(block);
    toggleFields();
  }

  // Toggle fields based on type
  $("#type").on("change", toggleFields);

  function toggleFields(){
    let type = $("#type").val();
    $(".objective-fields,.fill-fields,.theory-fields").hide();
    if(type === "objective"){ $(".objective-fields").show(); }
    if(type === "fill"){ $(".fill-fields").show(); }
    if(type === "theory"){ $(".theory-fields").show(); }
  }

  // Submit via AJAX (prevent redirect)
  $("#questionsForm").on("submit", function(e){
    e.preventDefault();

    let data = $(this).serializeArray();
    data.push({name:"session_id", value:$("#session").val()});
    data.push({name:"term_id", value:$("#term").val()});
    data.push({name:"class_id", value:$("#class").val()});
    data.push({name:"subject_id", value:$("#subject").val()});
    data.push({name:"type", value:$("#type").val()});
    data.push({name:"set_time_minutes", value:$("#set_time").val()});

    $.ajax({
      url: "save_questions.php",
      method: "POST",
      data: data,
      beforeSend: function(){
        $("#msg").html("Saving...").removeClass().addClass("text-blue-600");
      },
      success: function(res){
        $("#msg").html(res).removeClass().addClass("text-green-600");
        $("#questionsContainer").html("");
        addQuestionBlock();
        loadExistingQuestions();
      },
      error: function(){
        $("#msg").html("Error saving questions").removeClass().addClass("text-red-600");
      }
    });
  });

  // Load existing questions when filters change
  $("#session,#term,#class,#subject,#type").on("change", function(){
    loadExistingQuestions();
  });

  function loadExistingQuestions(){
    let session = $("#session").val();
    let term = $("#term").val();
    let klass = $("#class").val();
    let subject = $("#subject").val();
    let type = $("#type").val();

    if(!session || !term || !klass || !subject || !type){
      $("#questionsTable").html("<p class='text-gray-500'>Select all filters to view existing questions.</p>");
      return;
    }

    $.get("load_questions.php", {
      session_id:session,
      term_id:term,
      class_id:klass,
      subject_id:subject,
      type:type
    }, function(res){
      $("#questionsTable").html(res);
    });
  }
});
</script>








							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--end page wrapper -->
		<!--start overlay-->
		<div class="overlay toggle-icon"></div>
		<!--end overlay-->
		<!--Start Back To Top Button--> <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
		<!--End Back To Top Button-->
		<footer class="page-footer">
			<p class="mb-0">Copyright  2025. All right reserved.</p>
		</footer>
	</div>
	<!--end wrapper-->
	<!--start switcher-->
	<?php include 'includes/customiser.php'; ?>

	<!--end switcher-->
	<!-- Bootstrap JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<script src="assets/js/jquery.min.js"></script>
	<script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--app JS-->
	<script src="assets/js/app.js"></script>
</body>


</html>

