<?php 

include('includes/config.php');


?>


<?php
include('includes/user_data.php');

?>


<!doctype html>
<html lang="en">


<!-- Mirrored from codervent.com/rocker/demo/vertical/user-profile.html by HTTrack Website Copier/3.x [XR&CO'2014], Fri, 26 Aug 2022 06:47:36 GMT -->
<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!--favicon-->
	<link rel="icon" href="assets/images/favicon-32x32.png" type="image/png" />
	<!--plugins-->
	<link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
	<link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
	<link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
	<!-- loader-->
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
	<!-- Bootstrap CSS -->
	<link href="assets/css/bootstrap.min.css" rel="stylesheet">
	<link href="assets/css/bootstrap-extended.css" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&amp;display=swap" rel="stylesheet">
	<link href="assets/css/app.css" rel="stylesheet">
	<link href="assets/css/icons.css" rel="stylesheet">
	<!-- Theme Style CSS -->
	<link rel="stylesheet" href="assets/css/dark-theme.css" />
	<link rel="stylesheet" href="assets/css/semi-dark.css" />
	<link rel="stylesheet" href="assets/css/header-colors.css" />
	<title> class </title>
	  <script src="https://cdn.tailwindcss.com"></script>
</head>

<body>
	<!--wrapper-->
	<div class="wrapper">
		<!--sidebar wrapper -->
		<?php include 'includes/side.php'; ?>
		<!--end sidebar wrapper -->
		<!--start header -->
		<?php include 'includes/head.php'; ?>
		<!--end header -->
		<!--start page wrapper -->
		<div class="page-wrapper">
			<div class="page-content">
				<!--breadcrumb-->
				<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
					<div class="breadcrumb-title pe-3">User Profile</div>
					<div class="ps-3">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb mb-0 p-0">
								<li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
								</li>
								<li class="breadcrumb-item active" aria-current="page">Bank Profile</li>
							</ol>
						</nav>
					</div>
					
				</div>
				<!--end breadcrumb-->
				<div class="container">
					<div class="main-body">
						<div class="row">
						
							<div class="col-lg-8">
								<div class="card">
									<div class="card-body">
<?php


// Handle Add Class
if (isset($_POST['add_class'])) {
    $name = trim($_POST['class_name']);
    if (!empty($name)) {
        $stmt = $dbh->prepare("INSERT INTO classes (name) VALUES (?)");
        $stmt->execute([$name]);
    }
}

// Handle Assign Teacher
if (isset($_POST['assign_teacher'])) {
    $teacher_id = $_POST['teacher_id'];
    $class_id   = $_POST['class_id'];

    $stmt = $dbh->prepare("UPDATE teachers SET class = ? WHERE id = ?");
    $stmt->execute([$class_id, $teacher_id]);
}

// Handle Delete Class
if (isset($_GET['delete_class'])) {
    $class_id = $_GET['delete_class'];
    $stmt = $dbh->prepare("DELETE FROM classes WHERE id = ?");
    $stmt->execute([$class_id]);

    // optional: unassign teachers from deleted class
    $stmt = $dbh->prepare("UPDATE teachers SET class=NULL WHERE class=?");
    $stmt->execute([$class_id]);
}

// Fetch data
$classes  = $dbh->query("SELECT * FROM classes ORDER BY id DESC")->fetchAll();
$teachers = $dbh->query("SELECT * FROM teachers ORDER BY name ASC")->fetchAll();
?>




  <div class="max-w-6xl mx-auto space-y-6">

    <!-- Add Class -->
    <div class="bg-white p-6 rounded-2xl shadow">
      <h2 class="text-xl font-bold mb-4">➕ Add Class Arm</h2>
      <form method="POST" class="flex gap-3">
        <input type="text" name="class_name" placeholder="Enter class arm name"
               class="flex-1 border px-4 py-2 rounded-lg focus:outline-none focus:ring focus:ring-indigo-400">
        <button type="submit" name="add_class"
                class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700">Add</button>
      </form>
    </div>

    <!-- Assign Teacher -->
    <div class="bg-white p-6 rounded-2xl shadow">
      <h2 class="text-xl font-bold mb-4">👩‍🏫 Assign Teacher to Class</h2>
      <form method="POST" class="grid grid-cols-1 md:grid-cols-3 gap-3">
        <select name="teacher_id" class="border px-4 py-2 rounded-lg" required>
          <option value="">Select Teacher</option>
          <?php foreach ($teachers as $t): ?>
            <option value="<?= $t['id'] ?>"><?= htmlspecialchars($t['name']) ?> (<?= htmlspecialchars($t['email']) ?>)</option>
          <?php endforeach; ?>
        </select>
        <select name="class_id" class="border px-4 py-2 rounded-lg" required>
          <option value="">Select Class</option>
          <?php foreach ($classes as $c): ?>
            <option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['name']) ?></option>
          <?php endforeach; ?>
        </select>
        <button type="submit" name="assign_teacher"
                class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700">Assign</button>
      </form>
    </div>

    <!-- View Classes -->
    <div class="bg-white p-6 rounded-2xl shadow">
      <h2 class="text-xl font-bold mb-4">📋 Created Classes</h2>
      <div class="overflow-x-auto">
        <table class="w-full text-left border border-gray-200 rounded-lg">
          <thead class="bg-gray-100">
            <tr>
              <th class="px-4 py-2">#</th>
              <th class="px-4 py-2">Class Name</th>
              <th class="px-4 py-2">Assigned Teacher</th>
              <th class="px-4 py-2">Actions</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($classes as $index => $c): ?>
              <?php
                $stmt = $dbh->prepare("SELECT name,email FROM teachers WHERE class=? LIMIT 1");
                $stmt->execute([$c['id']]);
                $teacher = $stmt->fetch();
              ?>
              <tr class="border-t">
                <td class="px-4 py-2"><?= $index + 1 ?></td>
                <td class="px-4 py-2 font-medium"><?= htmlspecialchars($c['name']) ?></td>
                <td class="px-4 py-2">
                  <?php if ($teacher): ?>
                    <?= htmlspecialchars($teacher['name']) ?> (<?= htmlspecialchars($teacher['email']) ?>)
                  <?php else: ?>
                    <span class="text-gray-400 italic">No teacher assigned</span>
                  <?php endif; ?>
                </td>
                <td class="px-4 py-2">
                  <a href="?delete_class=<?= $c['id'] ?>"
                     onclick="return confirm('Delete this class?')"
                     class="text-red-600 hover:underline">Delete</a>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>

  </div>
	</div>
								</div>
								
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--end page wrapper -->
		<!--start overlay-->
		<div class="overlay toggle-icon"></div>
		<!--end overlay-->
		<!--Start Back To Top Button--> <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
		<!--End Back To Top Button-->
		<footer class="page-footer">
			<p class="mb-0">Copyright © 2024. All right reserved.</p>
		</footer>
	</div>
	<!--end wrapper-->
	<!--start switcher-->
	<?php include 'includes/customiser.php'; ?>

	<!--end switcher-->
	<!-- Bootstrap JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<script src="assets/js/jquery.min.js"></script>
	<script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--app JS-->
	<script src="assets/js/app.js"></script>
</body>


</html>

