<?php 

include('includes/config.php');


?>


<?php
include('includes/user_data.php');

?>
<?php


$teacher_id = $_SESSION['teacher_id'] ?? null;
if (!$teacher_id) {
    echo "You must be logged in as a teacher.";
    exit;
}

// Load dropdown data
$sessions = $dbh->query("SELECT id, session_year FROM sessions ORDER BY session_year DESC")->fetchAll(PDO::FETCH_ASSOC);
$terms    = $dbh->query("SELECT id, term_name FROM terms ORDER BY id")->fetchAll(PDO::FETCH_ASSOC);
$classes  = $dbh->query("SELECT id, name FROM classes ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
$subjects = $dbh->query("SELECT id, name FROM Subjects ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
?>


<!doctype html>
<html lang="en">


<!-- Mirrored from codervent.com/rocker/demo/vertical/user-profile.html by HTTrack Website Copier/3.x [XR&CO'2014], Fri, 26 Aug 2022 06:47:36 GMT -->
<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!--favicon-->
	<link rel="icon" href="assets/images/favicon-32x32.png" type="image/png" />
	<!--plugins-->
	<link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
	<link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
	<link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
	<!-- loader-->
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
	<!-- Bootstrap CSS -->
	<link href="assets/css/bootstrap.min.css" rel="stylesheet">
	<link href="assets/css/bootstrap-extended.css" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&amp;display=swap" rel="stylesheet">
	<link href="assets/css/app.css" rel="stylesheet">
	<link href="assets/css/icons.css" rel="stylesheet">
	<!-- Theme Style CSS -->
	<link rel="stylesheet" href="assets/css/dark-theme.css" />
	<link rel="stylesheet" href="assets/css/semi-dark.css" />
	<link rel="stylesheet" href="assets/css/header-colors.css" />

  <title>Copy Questions</title>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.tailwindcss.com"></script>
</head>

<body> 
	<!--wrapper-->
	<div class="wrapper">
		<!--sidebar wrapper -->
		<?php include 'includes/side.php'; ?>
		<!--end sidebar wrapper -->
		<!--start header -->
		<?php include 'includes/head.php'; ?>
		<!--end header -->
		<!--start page wrapper -->
		<div class="page-wrapper">
			<div class="page-content">
				<!--breadcrumb-->
				<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
					<div class="breadcrumb-title pe-3"></div>
					<div class="ps-3">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb mb-0 p-0">
								<li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
								</li>
								<li class="breadcrumb-item active" aria-current="page"></li>
							</ol>
						</nav>
					</div>
					
				</div>
				<!--end breadcrumb-->
				<div class="container">
					<div class="main-body">
						<div class="row">
						
							<div class="col-lg-12">
								<div class="card">
									<div class="card-body">



<?php
require 'config.php';
session_start();

$teacher_id = $_SESSION['teacher_id'] ?? null;
if (!$teacher_id) {
    echo "Unauthorized.";
    exit;
}

// Handle copy request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $src_class    = $_POST['src_class'] ?? null;
    $src_subject  = $_POST['src_subject'] ?? null;
    $src_term     = $_POST['src_term'] ?? null;
    $src_session  = $_POST['src_session'] ?? null;

    $dest_class   = $_POST['dest_class'] ?? null;
    $dest_subject = $_POST['dest_subject'] ?? null;
    $dest_term    = $_POST['dest_term'] ?? null;
    $dest_session = $_POST['dest_session'] ?? null;

    if ($src_class && $src_subject && $src_term && $src_session && $dest_class && $dest_subject && $dest_term && $dest_session) {
        // Fetch source questions
        $stmt = $dbh->prepare("SELECT * FROM questions 
            WHERE teacher_id=:t AND student_class=:c AND subject_id=:s 
              AND term_id=:tm AND session_id=:ss");
        $stmt->execute([
            ':t'=>$teacher_id,
            ':c'=>$src_class,
            ':s'=>$src_subject,
            ':tm'=>$src_term,
            ':ss'=>$src_session
        ]);
        $questions = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($questions) {
            $insert = $dbh->prepare("INSERT INTO questions 
                (teacher_id, student_class, term_id, session_id, subject_id, type, question_text, options, correct_answer, set_time_minutes)
                VALUES (:teacher_id,:class,:term,:session,:subject,:type,:text,:opts,:ans,:time)");

            foreach ($questions as $q) {
                $insert->execute([
                    ':teacher_id'=>$teacher_id,
                    ':class'=>$dest_class,
                    ':term'=>$dest_term,
                    ':session'=>$dest_session,
                    ':subject'=>$dest_subject,
                    ':type'=>$q['type'],
                    ':text'=>$q['question_text'],
                    ':opts'=>$q['options'],
                    ':ans'=>$q['correct_answer'],
                    ':time'=>$q['set_time_minutes']
                ]);
            }

            $msg = count($questions)." questions copied successfully!";
        } else {
            $msg = "No questions found in the source selection.";
        }
    } else {
        $msg = "Please select all source and destination fields.";
    }
}
?>


<div class="max-w-4xl mx-auto bg-white p-6 shadow rounded">
  <h1 class="text-xl font-bold mb-4">Copy Questions Between Classes/Subjects</h1>

  <?php if (!empty($msg)): ?>
    <div class="mb-4 p-3 rounded bg-blue-100 text-blue-700"><?=htmlspecialchars($msg)?></div>
  <?php endif; ?>

  <form method="post" class="grid grid-cols-1 md:grid-cols-2 gap-6">
    
    <!-- Source -->
    <div>
      <h2 class="font-semibold mb-2">Source</h2>
      <label class="block mb-1 text-sm">Session</label>
      <select name="src_session" class="w-full border p-2 rounded mb-2">
        <option value="">-- Select Session --</option>
        <?php
        $res=$dbh->query("SELECT * FROM sessions ORDER BY session_year DESC");
        foreach($res as $r) echo "<option value='{$r['id']}'>{$r['session_year']}</option>";
        ?>
      </select>

      <label class="block mb-1 text-sm">Term</label>
      <select name="src_term" class="w-full border p-2 rounded mb-2">
        <option value="">-- Select Term --</option>
        <?php
        $res=$dbh->query("SELECT * FROM terms");
        foreach($res as $r) echo "<option value='{$r['id']}'>{$r['term_name']}</option>";
        ?>
      </select>

      <label class="block mb-1 text-sm">Class</label>
      <select name="src_class" class="w-full border p-2 rounded mb-2">
        <option value="">-- Select Class --</option>
        <?php
        $res=$dbh->query("SELECT * FROM classes");
        foreach($res as $r) echo "<option value='{$r['id']}'>{$r['name']}</option>";
        ?>
      </select>

      <label class="block mb-1 text-sm">Subject</label>
      <select name="src_subject" class="w-full border p-2 rounded mb-2">
        <option value="">-- Select Subject --</option>
        <?php
        $res=$dbh->query("SELECT * FROM Subjects");
        foreach($res as $r) echo "<option value='{$r['id']}'>{$r['name']}</option>";
        ?>
      </select>
    </div>

    <!-- Destination -->
    <div>
      <h2 class="font-semibold mb-2">Destination</h2>
      <label class="block mb-1 text-sm">Session</label>
      <select name="dest_session" class="w-full border p-2 rounded mb-2">
        <option value="">-- Select Session --</option>
        <?php
        $res=$dbh->query("SELECT * FROM sessions ORDER BY session_year DESC");
        foreach($res as $r) echo "<option value='{$r['id']}'>{$r['session_year']}</option>";
        ?>
      </select>

      <label class="block mb-1 text-sm">Term</label>
      <select name="dest_term" class="w-full border p-2 rounded mb-2">
        <option value="">-- Select Term --</option>
        <?php
        $res=$dbh->query("SELECT * FROM terms");
        foreach($res as $r) echo "<option value='{$r['id']}'>{$r['term_name']}</option>";
        ?>
      </select>

      <label class="block mb-1 text-sm">Class</label>
      <select name="dest_class" class="w-full border p-2 rounded mb-2">
        <option value="">-- Select Class --</option>
        <?php
        $res=$dbh->query("SELECT * FROM classes");
        foreach($res as $r) echo "<option value='{$r['id']}'>{$r['name']}</option>";
        ?>
      </select>

      <label class="block mb-1 text-sm">Subject</label>
      <select name="dest_subject" class="w-full border p-2 rounded mb-2">
        <option value="">-- Select Subject --</option>
        <?php
        $res=$dbh->query("SELECT * FROM Subjects");
        foreach($res as $r) echo "<option value='{$r['id']}'>{$r['name']}</option>";
        ?>
      </select>
    </div>

    <div class="md:col-span-2 flex justify-end">
      <button type="submit" class="bg-blue-600 text-white px-6 py-2 rounded">Copy Questions</button>
    </div>
  </form>
</div>







							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--end page wrapper -->
		<!--start overlay-->
		<div class="overlay toggle-icon"></div>
		<!--end overlay-->
		<!--Start Back To Top Button--> <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
		<!--End Back To Top Button-->
		<footer class="page-footer">
			<p class="mb-0">Copyright © 2025. All right reserved.</p>
		</footer>
	</div>
	<!--end wrapper-->
	<!--start switcher-->
	<?php include 'includes/customiser.php'; ?>

	<!--end switcher-->
	<!-- Bootstrap JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<script src="assets/js/jquery.min.js"></script>
	<script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--app JS-->
	<script src="assets/js/app.js"></script>
</body>


</html>



