<?php 
include('includes/config.php');
include('includes/user_data.php');

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// fetch student
$stmt = $dbh->prepare("SELECT * FROM students WHERE id = :id AND class_id = :class_id");
$stmt->bindParam(':id', $id, PDO::PARAM_INT);
$stmt->bindParam(':class_id', $class, PDO::PARAM_INT);
$stmt->execute();
$student = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$student) {
    die("Student not found or not in your class.");
}

if (isset($_POST['update'])) {
    $name = $_POST['name'];
    $sex  = $_POST['sex'];
    $dob  = $_POST['dob'];
    $religion = $_POST['religion'];
    $address = $_POST['address'];
    $parent_name = $_POST['parent_name'];
    $parent_phone = $_POST['parent_phone'];

    $targetFilePath = $student['image']; // default old image

    if (!empty($_FILES['image']['name'])) {
        $imageName = $_FILES['image']['name'];
        $imageTmpName = $_FILES['image']['tmp_name'];
        $uploadDir = "uploads/";

        if (!file_exists($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }
        $targetFilePath = $uploadDir . basename($imageName);
        move_uploaded_file($imageTmpName, $targetFilePath);
    }

    $upd = $dbh->prepare("UPDATE students SET name=:name, sex=:sex, dob=:dob, religion=:religion, address=:address, parent_name=:parent_name, parent_phone=:parent_phone, image=:image WHERE id=:id AND class_id=:class_id");
    $upd->bindParam(':name', $name);
    $upd->bindParam(':sex', $sex);
    $upd->bindParam(':dob', $dob);
    $upd->bindParam(':religion', $religion);
    $upd->bindParam(':address', $address);
    $upd->bindParam(':parent_name', $parent_name);
    $upd->bindParam(':parent_phone', $parent_phone);
    $upd->bindParam(':image', $targetFilePath);
    $upd->bindParam(':id', $id);
    $upd->bindParam(':class_id', $class);

    if ($upd->execute()) {
        $msg = "Student updated successfully.";
        // reload student
        $stmt->execute();
        $student = $stmt->fetch(PDO::FETCH_ASSOC);
    } else {
        $error = "Update failed.";
    }
}
?>
<!doctype html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!--favicon-->
	<link rel="icon" href="assets/images/favicon-32x32.png" type="image/png" />
	<!--plugins-->
	<link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
	<link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
	<link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
	<!-- loader-->
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
	<!-- Bootstrap CSS -->
	<link href="assets/css/bootstrap.min.css" rel="stylesheet">
	<link href="assets/css/bootstrap-extended.css" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&amp;display=swap" rel="stylesheet">
	<link href="assets/css/app.css" rel="stylesheet">
	<link href="assets/css/icons.css" rel="stylesheet">
	<!-- Theme Style CSS -->
	<link rel="stylesheet" href="assets/css/dark-theme.css" />
	<link rel="stylesheet" href="assets/css/semi-dark.css" />
	<link rel="stylesheet" href="assets/css/header-colors.css" />
	<title>Edit Student - Dominion</title>
	<link href="assets/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="wrapper">
	<?php include 'includes/side.php'; ?>
	<?php include 'includes/head.php'; ?>

	<div class="page-wrapper">
		<div class="container mt-5">
			<div class="card shadow-lg rounded-3">
				<div class="card-header bg-warning text-dark">
					<h5>Edit Student: <?php echo htmlentities($student['name']); ?></h5>
				</div>
				<div class="card-body">
					<?php if(!empty($error)): ?>
						<div class="alert alert-danger"><?php echo htmlentities($error); ?></div>
					<?php elseif(!empty($msg)): ?>
						<div class="alert alert-success"><?php echo htmlentities($msg); ?></div>
					<?php endif; ?>

					<form class="row g-3" method="post" enctype="multipart/form-data">
						<div class="col-md-6">
							<label class="form-label">Full Name</label>
							<input type="text" name="name" value="<?php echo htmlentities($student['name']); ?>" class="form-control" required>
						</div>
						<div class="col-md-6">
							<label class="form-label">Sex</label>
							<select class="form-select" name="sex">
								<option value="Male" <?php if($student['sex']=="Male") echo "selected"; ?>>Male</option>
								<option value="Female" <?php if($student['sex']=="Female") echo "selected"; ?>>Female</option>
							</select>
						</div>
						<div class="col-md-6">
							<label class="form-label">DOB</label>
							<input type="date" name="dob" value="<?php echo htmlentities($student['dob']); ?>" class="form-control">
						</div>
						<div class="col-md-6">
							<label class="form-label">Religion</label>
							<select class="form-select" name="religion">
								<option value="Christian" <?php if($student['religion']=="Christian") echo "selected"; ?>>Christian</option>
								<option value="Muslim" <?php if($student['religion']=="Muslim") echo "selected"; ?>>Muslim</option>
								<option value="Traditional" <?php if($student['religion']=="Traditional") echo "selected"; ?>>Traditional</option>
							</select>
						</div>
						<div class="col-12">
							<label class="form-label">Address</label>
							<input type="text" name="address" value="<?php echo htmlentities($student['address']); ?>" class="form-control">
						</div>
						<div class="col-md-6">
							<label class="form-label">Parent Name</label>
							<input type="text" name="parent_name" value="<?php echo htmlentities($student['parent_name']); ?>" class="form-control">
						</div>
						<div class="col-md-6">
							<label class="form-label">Parent Phone</label>
							<input type="text" name="parent_phone" value="<?php echo htmlentities($student['parent_phone']); ?>" class="form-control">
						</div>
						<div class="col-12">
							<label class="form-label">Image</label><br>
							<img src="<?php echo htmlentities($student['image']); ?>" width="80" class="rounded mb-2"><br>
							<input type="file" name="image" class="form-control">
						</div>
						<div class="col-12 d-grid">
							<button type="submit" name="update" class="btn btn-warning">Update Student</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!-- Bootstrap JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<script src="assets/js/jquery.min.js"></script>
	<script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--app JS-->
	<script src="assets/js/app.js"></script>
</body>
</html>
