<?php 

include('includes/config.php');


?>


<?php
include('includes/user_data.php');

?>


<!doctype html>
<html lang="en">


<!-- Mirrored from codervent.com/rocker/demo/vertical/user-profile.html by HTTrack Website Copier/3.x [XR&CO'2014], Fri, 26 Aug 2022 06:47:36 GMT -->
<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!--favicon-->
	<link rel="icon" href="assets/images/favicon-32x32.png" type="image/png" />
	<!--plugins-->
	<link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
	<link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
	<link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
	<!-- loader-->
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
	<!-- Bootstrap CSS -->
	<link href="assets/css/bootstrap.min.css" rel="stylesheet">
	<link href="assets/css/bootstrap-extended.css" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&amp;display=swap" rel="stylesheet">
	<link href="assets/css/app.css" rel="stylesheet">
	<link href="assets/css/icons.css" rel="stylesheet">
	<!-- Theme Style CSS -->
	<link rel="stylesheet" href="assets/css/dark-theme.css" />
	<link rel="stylesheet" href="assets/css/semi-dark.css" />
	<link rel="stylesheet" href="assets/css/header-colors.css" />
<title>School Fees Management</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body>
	<!--wrapper-->
	<div class="wrapper">
		<!--sidebar wrapper -->
		<?php include 'includes/side.php'; ?>
		<!--end sidebar wrapper -->
		<!--start header -->
		<?php include 'includes/head.php'; ?>
		<!--end header -->
		<!--start page wrapper -->
		<div class="page-wrapper">
			<div class="page-content">
				<!--breadcrumb-->
				<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
					<div class="breadcrumb-title pe-3"></div>
					<div class="ps-3">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb mb-0 p-0">
								<li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
								</li>
								<li class="breadcrumb-item active" aria-current="page"></li>
							</ol>
						</nav>
					</div>
					
				</div>
				<!--end breadcrumb-->
				<div class="container">
					<div class="main-body">
						<div class="row">
						
							<div class="col-lg-12">
								<div class="card">
									<div class="card-body">
<?php
require 'config.php';

// Handle Add Fee
if (isset($_POST['add_fee'])) {
    $class_id = $_POST['class_id'];
    $session_id = $_POST['session_id'];
    $term_id = $_POST['term_id'];
    $amount = $_POST['amount'];

    $stmt = $dbh->prepare("INSERT INTO fees (class_id, session_id, term_id, amount) VALUES (?, ?, ?, ?)");
    $stmt->execute([$class_id, $session_id, $term_id, $amount]);
       $extra="fees.php?success=1";
			$host  = $_SERVER['HTTP_HOST'];
			$uri  = rtrim(dirname($_SERVER['PHP_SELF']),'/\\');
			echo "<script type='text/javascript'> document.location = 'https://$host$uri/$extra'; </script>";
    exit;
}

// Handle Delete
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $dbh->prepare("DELETE FROM fees WHERE id = ?");
    $stmt->execute([$id]);
       $extra="fees.php?deleted=1";
			$host  = $_SERVER['HTTP_HOST'];
			$uri  = rtrim(dirname($_SERVER['PHP_SELF']),'/\\');
			echo "<script type='text/javascript'> document.location = 'https://$host$uri/$extra'; </script>";
    exit;
}

// Handle Update
if (isset($_POST['update_fee'])) {
    $id = $_POST['id'];
    $class_id = $_POST['class_id'];
    $session_id = $_POST['session_id'];
    $term_id = $_POST['term_id'];
    $amount = $_POST['amount'];

    $stmt = $dbh->prepare("UPDATE fees SET class_id=?, session_id=?, term_id=?, amount=? WHERE id=?");
    $stmt->execute([$class_id, $session_id, $term_id, $amount, $id]);
       $extra="fees.php?updated=1";
			$host  = $_SERVER['HTTP_HOST'];
			$uri  = rtrim(dirname($_SERVER['PHP_SELF']),'/\\');
			echo "<script type='text/javascript'> document.location = 'https://$host$uri/$extra'; </script>";
    exit;
}

// Fetch dropdowns
$sessions = $dbh->query("SELECT * FROM sessions")->fetchAll();
$terms = $dbh->query("SELECT * FROM terms")->fetchAll();
$classes = $dbh->query("SELECT * FROM classes")->fetchAll();

// Fetch fees
$fees = $dbh->query("
    SELECT fees.*, classes.name AS class_name, sessions.session_year, terms.term_name
    FROM fees 
    JOIN classes ON fees.class_id = classes.id
    JOIN sessions ON fees.session_id = sessions.id
    JOIN terms ON fees.term_id = terms.id
    ORDER BY fees.id DESC
")->fetchAll();
?>

  
  <div class="max-w-5xl mx-auto bg-white shadow-lg rounded-2xl p-6">
    <h1 class="text-2xl font-bold text-gray-700 mb-4">💰 School Fees Management</h1>

    <!-- Add Fee Form -->
    <form method="POST" class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
      <select name="class_id" required class="p-2 border rounded-lg">
        <option value="">Select Class</option>
        <?php foreach ($classes as $c): ?>
          <option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['name']) ?></option>
        <?php endforeach; ?>
      </select>

      <select name="session_id" required class="p-2 border rounded-lg">
        <option value="">Select Session</option>
        <?php foreach ($sessions as $s): ?>
          <option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['session_year']) ?></option>
        <?php endforeach; ?>
      </select>

      <select name="term_id" required class="p-2 border rounded-lg">
        <option value="">Select Term</option>
        <?php foreach ($terms as $t): ?>
          <option value="<?= $t['id'] ?>"><?= htmlspecialchars($t['term_name']) ?></option>
        <?php endforeach; ?>
      </select>

      <input type="number" step="0.01" name="amount" placeholder="Amount" required class="p-2 border rounded-lg">

      <button type="submit" name="add_fee" class="col-span-1 md:col-span-4 bg-blue-600 text-white p-2 rounded-lg hover:bg-blue-700 transition">
        ➕ Add Fee
      </button>
    </form>

    <!-- Fees Table -->
    <div class="overflow-x-auto">
      <table class="w-full border-collapse bg-white shadow-md rounded-lg">
        <thead class="bg-gray-200 text-gray-700">
          <tr>
            <th class="p-3 text-left">Class</th>
            <th class="p-3 text-left">Session</th>
            <th class="p-3 text-left">Term</th>
            <th class="p-3 text-left">Amount (₦)</th>
            <th class="p-3 text-center">Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($fees as $fee): ?>
            <tr class="border-b hover:bg-gray-50">
              <td class="p-3"><?= htmlspecialchars($fee['class_name']) ?></td>
              <td class="p-3"><?= htmlspecialchars($fee['session_year']) ?></td>
              <td class="p-3"><?= htmlspecialchars($fee['term_name']) ?></td>
              <td class="p-3 font-semibold">₦<?= number_format($fee['amount'], 2) ?></td>
              <td class="p-3 text-center">
                <button 
                  onclick="openEditModal(<?= $fee['id'] ?>, <?= $fee['class_id'] ?>, <?= $fee['session_id'] ?>, <?= $fee['term_id'] ?>, <?= $fee['amount'] ?>)"
                  class="bg-green-500 text-white px-3 py-1 rounded-lg hover:bg-green-600">✏️ Edit</button>

                <a href="fees.php?delete=<?= $fee['id'] ?>" 
                   onclick="return confirm('Are you sure you want to delete this fee?')" 
                   class="bg-red-500 text-white px-3 py-1 rounded-lg hover:bg-red-600 ml-2">
                  🗑️ Delete
                </a>
              </td>
            </tr>
          <?php endforeach; ?>
          <?php if (empty($fees)): ?>
            <tr>
              <td colspan="5" class="text-center p-4 text-gray-500">No fees added yet.</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- EDIT MODAL -->
  <div id="editModal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center">
    <div class="bg-white p-6 rounded-2xl w-96 shadow-lg relative">
      <h2 class="text-xl font-bold mb-4 text-gray-700">✏️ Edit Fee</h2>
      <form method="POST" class="space-y-3">
        <input type="hidden" name="id" id="edit_id">

        <select name="class_id" id="edit_class" required class="w-full p-2 border rounded-lg">
          <option value="">Select Class</option>
          <?php foreach ($classes as $c): ?>
            <option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['name']) ?></option>
          <?php endforeach; ?>
        </select>

        <select name="session_id" id="edit_session" required class="w-full p-2 border rounded-lg">
          <option value="">Select Session</option>
          <?php foreach ($sessions as $s): ?>
            <option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['session_year']) ?></option>
          <?php endforeach; ?>
        </select>

        <select name="term_id" id="edit_term" required class="w-full p-2 border rounded-lg">
          <option value="">Select Term</option>
          <?php foreach ($terms as $t): ?>
            <option value="<?= $t['id'] ?>"><?= htmlspecialchars($t['term_name']) ?></option>
          <?php endforeach; ?>
        </select>

        <input type="number" step="0.01" name="amount" id="edit_amount" required class="w-full p-2 border rounded-lg">

        <div class="flex justify-between mt-4">
          <button type="button" onclick="closeEditModal()" class="px-4 py-2 rounded-lg border">❌ Cancel</button>
          <button type="submit" name="update_fee" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">💾 Save</button>
        </div>
      </form>
    </div>
  </div>

  <script>
    function openEditModal(id, classId, sessionId, termId, amount) {
      document.getElementById('edit_id').value = id;
      document.getElementById('edit_class').value = classId;
      document.getElementById('edit_session').value = sessionId;
      document.getElementById('edit_term').value = termId;
      document.getElementById('edit_amount').value = amount;
      document.getElementById('editModal').classList.remove('hidden');
    }
    function closeEditModal() {
      document.getElementById('editModal').classList.add('hidden');
    }
  </script>






								</div>
								
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--end page wrapper -->
		<!--start overlay-->
		<div class="overlay toggle-icon"></div>
		<!--end overlay-->
		<!--Start Back To Top Button--> <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
		<!--End Back To Top Button-->
		<footer class="page-footer">
			<p class="mb-0">Copyright © 2024. All right reserved.</p>
		</footer>
	</div>
	<!--end wrapper-->
	<!--start switcher-->
	<?php include 'includes/customiser.php'; ?>

	<!--end switcher-->
	<!-- Bootstrap JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<script src="assets/js/jquery.min.js"></script>
	<script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--app JS-->
	<script src="assets/js/app.js"></script>
</body>


</html>

