<?php
include('config.php');

if ($conn->connect_error) die("Connection failed");

// Get parameters
$class = $_GET['class'];
$term = $_GET['term'];

// Prepare and execute the query
$sql = $conn->prepare("
    SELECT DISTINCT s.Admission_num, s.name 
    FROM end_term_report e
    INNER JOIN students s ON e.Admission_no = s.Admission_num
    WHERE e.classes = ? AND e.term = ?
    ORDER BY s.name ASC
");
$sql->bind_param("ss", $class, $term);
$sql->execute();
$result = $sql->get_result();

// Build result array
$admissionList = [];
while($row = $result->fetch_assoc()) {
    $admissionList[] = [
        'admission_no' => $row['Admission_num'],
        'name' => $row['name']
    ];
}

// Output as JSON
echo json_encode($admissionList);

