<?php
// load_students.php
require_once 'includes/config.php';

$class_id = isset($_GET['class_id']) ? (int) $_GET['class_id'] : 0;

if ($class_id) {
    // Query to fetch students based on selected class
    $query = "SELECT s.*, c.name AS class_name FROM students s 
              LEFT JOIN classes c ON s.class_id = c.id 
              WHERE s.class_id = :class_id";
    $stmt = $dbh->prepare($query);
    $stmt->bindParam(':class_id', $class_id, PDO::PARAM_INT);
    $stmt->execute();
    
    // Fetch the students
    $students = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Return the students as a JSON response
    echo json_encode(['students' => $students]);
} else {
    echo json_encode(['students' => []]);
}
?>
