<?php 

include('includes/config.php');


?>


<?php
include('includes/user_data.php');

?>


<!doctype html>
<html lang="en">


<!-- Mirrored from codervent.com/rocker/demo/vertical/user-profile.html by HTTrack Website Copier/3.x [XR&CO'2014], Fri, 26 Aug 2022 06:47:36 GMT -->
<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!--favicon-->
	<link rel="icon" href="assets/images/favicon-32x32.png" type="image/png" />
	<!--plugins-->
	<link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
	<link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
	<link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
	<!-- loader-->
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
	<!-- Bootstrap CSS -->
	<link href="assets/css/bootstrap.min.css" rel="stylesheet">
	<link href="assets/css/bootstrap-extended.css" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&amp;display=swap" rel="stylesheet">
	<link href="assets/css/app.css" rel="stylesheet">
	<link href="assets/css/icons.css" rel="stylesheet">
	<!-- Theme Style CSS -->
	<link rel="stylesheet" href="assets/css/dark-theme.css" />
	<link rel="stylesheet" href="assets/css/semi-dark.css" />
	<link rel="stylesheet" href="assets/css/header-colors.css" />
  <title>Mark Attendance</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body>
	<!--wrapper-->
	<div class="wrapper">
		<!--sidebar wrapper -->
		<?php include 'includes/side.php'; ?>
		<!--end sidebar wrapper -->
		<!--start header -->
		<?php include 'includes/head.php'; ?>
		<!--end header -->
		<!--start page wrapper -->
		<div class="page-wrapper">
			<div class="page-content">
				<!--breadcrumb-->
				<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
					<div class="breadcrumb-title pe-3"></div>
					<div class="ps-3">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb mb-0 p-0">
								<li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
								</li>
								<li class="breadcrumb-item active" aria-current="page"></li>
							</ol>
						</nav>
					</div>
					
				</div>
				<!--end breadcrumb-->
				<div class="container">
					<div class="main-body">
						<div class="row">
						
							<div class="col-lg-12">
								<div class="card">
									<div class="card-body">
<?php


// Ensure teacher logged in
$_SESSION['teacher_id']=$teacher_id;
if (!isset($_SESSION['teacher_id'])) {
    header("Location: login.php");
    exit;
}

$teacher_id = $_SESSION['teacher_id'];
$teacherQuery = $dbh->prepare("SELECT * FROM teachers WHERE id=?");
$teacherQuery->execute([$teacher_id]);
$teacher = $teacherQuery->fetch();

$class_id = $teacher['class'];

// Fetch class name
$classQuery = $dbh->prepare("SELECT * FROM classes WHERE id=?");
$classQuery->execute([$class_id]);
$class = $classQuery->fetch();

// Get latest session & term
$session = $dbh->query("SELECT * FROM sessions ORDER BY id DESC LIMIT 1")->fetch();
$term = $dbh->query("SELECT * FROM terms ORDER BY id DESC LIMIT 1")->fetch();

// Fetch students
$studentsQuery = $dbh->prepare("SELECT * FROM students WHERE class_id=? ORDER BY name ASC");
$studentsQuery->execute([$class_id]);
$students = $studentsQuery->fetchAll();

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $date = $_POST['date'];
    foreach ($_POST['attendance'] as $student_id => $status) {
        $stmt = $dbh->prepare("INSERT INTO attendance (student_id, class_id, session_id, term_id, date, status, marked_by)
                               VALUES (?,?,?,?,?,?,?)
                               ON DUPLICATE KEY UPDATE status=?");
        $stmt->execute([$student_id, $class_id, $session['id'], $term['id'], $date, $status, $teacher_id, $status]);
    }
    $message = "Attendance marked successfully!";
}
?>

 
  <div class="max-w-5xl mx-auto bg-white shadow-lg rounded-xl p-6">
    <h1 class="text-2xl font-bold mb-2 text-center">Manual School Register</h1>
    <p class="text-center text-gray-600 mb-6">
      Class: <strong><?= $class['name'] ?></strong> | 
      Teacher: <strong><?= $teacher['name'] ?></strong> | 
      Session: <strong><?= $session['session_year'] ?></strong>
     
    </p>

    <?php if (!empty($message)): ?>
      <div class="mb-4 p-3 bg-green-100 text-green-700 rounded"><?= $message ?></div>
    <?php endif; ?>

    <form method="POST">
      <label class="block mb-2 font-semibold">Select Date</label>
      <input type="date" name="date" class="border rounded p-2 mb-4 w-60" required>

      <div class="overflow-x-auto">
        <table class="w-full border-collapse border border-gray-300 text-sm">
          <thead>
            <tr class="bg-gray-200 text-left">
              <th class="border p-2">#</th>
              <th class="border p-2">Admission No</th>
              <th class="border p-2">Name</th>
              <th class="border p-2 text-center">Present</th>
              <th class="border p-2 text-center">Absent</th>
              <th class="border p-2 text-center">Late</th>
            </tr>
          </thead>
          <tbody>
            <?php $sn=1; foreach($students as $st): ?>
            <tr class="hover:bg-gray-50">
              <td class="border p-2"><?= $sn++ ?></td>
              <td class="border p-2"><?= $st['Admission_num'] ?></td>
              <td class="border p-2"><?= $st['name'] ?></td>
              <td class="border text-center">
                <input type="radio" name="attendance[<?= $st['id'] ?>]" value="P" required>
              </td>
              <td class="border text-center">
                <input type="radio" name="attendance[<?= $st['id'] ?>]" value="A">
              </td>
              <td class="border text-center">
                <input type="radio" name="attendance[<?= $st['id'] ?>]" value="L">
              </td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>

      <button type="submit" class="mt-4 bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
        Save Attendance
      </button>
    </form>
  </div>






								</div>
								
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--end page wrapper -->
		<!--start overlay-->
		<div class="overlay toggle-icon"></div>
		<!--end overlay-->
		<!--Start Back To Top Button--> <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
		<!--End Back To Top Button-->
		<footer class="page-footer">
			<p class="mb-0">Copyright © 2024. All right reserved.</p>
		</footer>
	</div>
	<!--end wrapper-->
	<!--start switcher-->
	<?php include 'includes/customiser.php'; ?>

	<!--end switcher-->
	<!-- Bootstrap JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<script src="assets/js/jquery.min.js"></script>
	<script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--app JS-->
	<script src="assets/js/app.js"></script>
</body>


</html>

