<?php 
include('includes/config.php');
include('includes/user_data.php'); // ensures $teacher or $class info is available
?>

<?php
if (isset($_POST['reg'])) {
    $class_id   = $_POST['class_id'];
    $Admission_num = $_POST['Admission_num']; 
    $name       = $_POST['name']; 
    $sex        = $_POST['sex'];
    $dob        = $_POST['dob']; 
    $religion   = $_POST['religion'];
    $address    = $_POST['address']; 
    $parent_name= $_POST['parent_name'];
    $parent_phone= $_POST['parent_phone'];

    // Upload Image
    $imageName = $_FILES['image']['name'];
    $imageTmpName = $_FILES['image']['tmp_name'];
    $uploadDir = "uploads/";

    if (!file_exists($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }
    $targetFilePath = $uploadDir . basename($imageName);

    if (!move_uploaded_file($imageTmpName, $targetFilePath)) {
        $error = "Error uploading image.";
    }

    // Ensure admission number unique
    $sql ="SELECT Admission_num FROM students WHERE Admission_num=:Admission_num";
    $query= $dbh -> prepare($sql);
    $query-> bindParam(':Admission_num', $Admission_num, PDO::PARAM_STR);
    $query-> execute();

    if ($query -> rowCount() > 0) {
        $error = "Admission number already exists.";
    } else {
        $insert = $dbh->prepare("INSERT INTO students 
            (class_id, Admission_num, name, sex, dob, religion, address, image, parent_name, parent_phone, date, status) 
            VALUES (:class_id, :Admission_num, :name, :sex, :dob, :religion, :address, :image, :parent_name, :parent_phone, NOW(), 1)");
        $insert->bindParam(':class_id', $class_id);
        $insert->bindParam(':Admission_num', $Admission_num);
        $insert->bindParam(':name', $name);
        $insert->bindParam(':sex', $sex);
        $insert->bindParam(':dob', $dob);
        $insert->bindParam(':religion', $religion);
        $insert->bindParam(':address', $address);
        $insert->bindParam(':image', $targetFilePath);
        $insert->bindParam(':parent_name', $parent_name);
        $insert->bindParam(':parent_phone', $parent_phone);

        if ($insert->execute()) {
            $msg = "Student successfully registered.";
        } else {
            $error = "Something went wrong, try again.";
        }
    }
}

// fetch class name of teacher
$class_name = "";
if (!empty($class)) {
    $stmt = $dbh->prepare("SELECT name FROM classes WHERE id = :id");
    $stmt->bindParam(':id', $class, PDO::PARAM_INT);
    $stmt->execute();
    $cls = $stmt->fetch(PDO::FETCH_ASSOC);
    $class_name = $cls ? $cls['name'] : "";
}
?>
<!doctype html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!--favicon-->
	<link rel="icon" href="assets/images/favicon-32x32.png" type="image/png" />
	<!--plugins-->
	<link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
	<link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
	<link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
	<!-- loader-->
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
	<!-- Bootstrap CSS -->
	<link href="assets/css/bootstrap.min.css" rel="stylesheet">
	<link href="assets/css/bootstrap-extended.css" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&amp;display=swap" rel="stylesheet">
	<link href="assets/css/app.css" rel="stylesheet">
	<link href="assets/css/icons.css" rel="stylesheet">
	<!-- Theme Style CSS -->
	<link rel="stylesheet" href="assets/css/dark-theme.css" />
	<link rel="stylesheet" href="assets/css/semi-dark.css" />
	<link rel="stylesheet" href="assets/css/header-colors.css" />
	<title>Register Student - Dominion</title>
	<link href="assets/css/bootstrap.min.css" rel="stylesheet">
	<link href="assets/css/app.css" rel="stylesheet">
</head>
<body>
<div class="wrapper">
	<?php include 'includes/side.php'; ?>
	<?php include 'includes/head.php'; ?>

	<div class="page-wrapper">
		<div class="row justify-content-center mt-5">
			<div class="col-md-7">
				<div class="card shadow-lg rounded-3">
					<div class="card-header text-center bg-primary text-white">
						<h5>Register New Student</h5>
					</div>
					<div class="card-body">
						<?php if(!empty($error)): ?>
							<div class="alert alert-danger"><?php echo htmlentities($error); ?></div>
						<?php elseif(!empty($msg)): ?>
							<div class="alert alert-success"><?php echo htmlentities($msg); ?></div>
						<?php endif; ?>

						<form class="row g-3" action="" method="post" enctype="multipart/form-data">
							
							<div class="col-12">
								<label class="form-label">Upload Image</label>
								<input type="file" name="image" accept="image/*" required class="form-control">
							</div>

							<div class="col-md-6">
								<label class="form-label">Class</label>
								<input type="text" name="class_id" value="<?php echo $class; ?>" hidden>
								<input type="text" value="<?php echo htmlentities($class_name); ?>" class="form-control" readonly>
							</div>

							<div class="col-md-6">
								<label class="form-label">Admission Number</label>
								<input type="text" name="Admission_num" value="PC<?php echo rand(10000,99999); ?>" class="form-control" readonly>
							</div>

							<div class="col-12">
								<label class="form-label">Full Name</label>
								<input type="text" name="name" class="form-control" required>
							</div>

							<div class="col-md-6">
								<label class="form-label">Sex</label>
								<select class="form-select" name="sex">
									<option value="Male">Male</option>
									<option value="Female">Female</option>
								</select>
							</div>

							<div class="col-md-6">
								<label class="form-label">DOB</label>
								<input type="date" name="dob" class="form-control" required>
							</div>

							<div class="col-md-6">
								<label class="form-label">Religion</label>
								<select class="form-select" name="religion">
									<option value="Christian">Christian</option>
									<option value="Muslim">Muslim</option>
									<option value="Traditional">Traditional</option>
								</select>
							</div>

							<div class="col-12">
								<label class="form-label">Address</label>
								<input type="text" name="address" class="form-control">
							</div>

							<div class="col-md-6">
								<label class="form-label">Parent Name</label>
								<input type="text" name="parent_name" class="form-control">
							</div>

							<div class="col-md-6">
								<label class="form-label">Parent Phone</label>
								<input type="text" name="parent_phone" class="form-control">
							</div>

							<div class="col-12 d-grid">
								<button type="submit" name="reg" class="btn btn-primary">Register Student</button>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!-- Bootstrap JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<script src="assets/js/jquery.min.js"></script>
	<script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--app JS-->
	<script src="assets/js/app.js"></script>
</body>
</html>
