<?php 

include('includes/config.php');


?>


<?php
include('includes/user_data.php');

?>


<!doctype html>
<html lang="en">


<!-- Mirrored from codervent.com/rocker/demo/vertical/user-profile.html by HTTrack Website Copier/3.x [XR&CO'2014], Fri, 26 Aug 2022 06:47:36 GMT -->
<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!--favicon-->
	<link rel="icon" href="assets/images/favicon-32x32.png" type="image/png" />
	<!--plugins-->
	<link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
	<link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
	<link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
	<!-- loader-->
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
	<!-- Bootstrap CSS -->
	<link href="assets/css/bootstrap.min.css" rel="stylesheet">
	<link href="assets/css/bootstrap-extended.css" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&amp;display=swap" rel="stylesheet">
	<link href="assets/css/app.css" rel="stylesheet">
	<link href="assets/css/icons.css" rel="stylesheet">
	<!-- Theme Style CSS -->
	<link rel="stylesheet" href="assets/css/dark-theme.css" />
	<link rel="stylesheet" href="assets/css/semi-dark.css" />
	<link rel="stylesheet" href="assets/css/header-colors.css" />
  <title>Manage Sessions</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    // Open edit modal with data
    function openEditModal(id, year) {
      document.getElementById("editModal").classList.remove("hidden");
      document.getElementById("edit_session_id").value = id;
      document.getElementById("edit_session_year").value = year;
    }
    function closeEditModal() {
      document.getElementById("editModal").classList.add("hidden");
    }
  </script>
</head>
<body>
	<!--wrapper-->
	<div class="wrapper">
		<!--sidebar wrapper -->
		<?php include 'includes/side.php'; ?>
		<!--end sidebar wrapper -->
		<!--start header -->
		<?php include 'includes/head.php'; ?>
		<!--end header -->
		<!--start page wrapper -->
		<div class="page-wrapper">
			<div class="page-content">
				<!--breadcrumb-->
				<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
					<div class="breadcrumb-title pe-3"></div>
					<div class="ps-3">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb mb-0 p-0">
								<li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
								</li>
								<li class="breadcrumb-item active" aria-current="page"></li>
							</ol>
						</nav>
					</div>
					
				</div>
				<!--end breadcrumb-->
				<div class="container">
					<div class="main-body">
						<div class="row">
						
							<div class="col-lg-12">
								<div class="card">
									<div class="card-body">
<?php


// Handle Add Session
if (isset($_POST['add_session'])) {
    $session_year = trim($_POST['session_year']);
    if (!empty($session_year)) {
        $stmt = $dbh->prepare("INSERT INTO sessions (session_year) VALUES (:session_year)");
        $stmt->execute(['session_year' => $session_year]);
        $success = "Session added successfully!";
    } else {
        $error = "Please enter a valid session year.";
    }
}

// Handle Delete Session
if (isset($_GET['delete'])) {
    $id = (int) $_GET['delete'];
    $stmt = $dbh->prepare("DELETE FROM sessions WHERE id = :id");
    $stmt->execute(['id' => $id]);

    $extra="sessions.php";
			$host  = $_SERVER['HTTP_HOST'];
			$uri  = rtrim(dirname($_SERVER['PHP_SELF']),'/\\');
			echo "<script type='text/javascript'> document.location = 'https://$host$uri/$extra'; </script>";
    exit;
}

// Handle Edit Session
if (isset($_POST['edit_session'])) {
    $id = (int) $_POST['session_id'];
    $session_year = trim($_POST['session_year']);
    if (!empty($session_year)) {
        $stmt = $dbh->prepare("UPDATE sessions SET session_year = :session_year WHERE id = :id");
        $stmt->execute(['session_year' => $session_year, 'id' => $id]);
        $success = "Session updated successfully!";
    } else {
        $error = "Please enter a valid session year.";
    }
}

// Fetch Sessions
$stmt = $dbh->query("SELECT * FROM sessions ORDER BY id DESC");
$sessions = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>


  <div class="w-full max-w-3xl bg-white rounded-2xl shadow-lg p-6 relative">
    <h1 class="text-2xl font-bold text-gray-800 mb-4">Manage Academic Sessions</h1>

    <!-- Messages -->
    <?php if (!empty($success)): ?>
      <p class="mb-3 text-green-600 font-medium"><?= htmlspecialchars($success) ?></p>
    <?php elseif (!empty($error)): ?>
      <p class="mb-3 text-red-600 font-medium"><?= htmlspecialchars($error) ?></p>
    <?php endif; ?>

    <!-- Add Session Form -->
    <form method="post" class="flex items-center gap-3 mb-6">
      <input 
        type="text" 
        name="session_year" 
        placeholder="Enter Session (e.g. 2024/2025)" 
        class="flex-1 px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 outline-none"
      >
      <button 
        type="submit" 
        name="add_session" 
        class="px-5 py-2 bg-blue-600 text-white font-semibold rounded-lg hover:bg-blue-700 transition">
        Add
      </button>
    </form>

    <!-- Sessions Table -->
    <div class="overflow-x-auto">
      <table class="w-full text-left border-collapse">
        <thead>
          <tr class="bg-gray-200 text-gray-700">
            <th class="px-4 py-2">#</th>
            <th class="px-4 py-2">Session Year</th>
            <th class="px-4 py-2">Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php if (count($sessions) > 0): ?>
            <?php foreach ($sessions as $index => $session): ?>
              <tr class="border-b hover:bg-gray-50">
                <td class="px-4 py-2"><?= $index + 1 ?></td>
                <td class="px-4 py-2"><?= htmlspecialchars($session['session_year']) ?></td>
                <td class="px-4 py-2 flex gap-2">
                  <button 
                    onclick="openEditModal('<?= $session['id'] ?>','<?= htmlspecialchars($session['session_year']) ?>')" 
                    class="px-3 py-1 bg-yellow-500 text-white rounded-md hover:bg-yellow-600 transition">
                    Edit
                  </button>
                  <a 
                    href="sessions.php?delete=<?= $session['id'] ?>" 
                    onclick="return confirm('Are you sure you want to delete this session?')" 
                    class="px-3 py-1 bg-red-500 text-white rounded-md hover:bg-red-600 transition">
                    Delete
                  </a>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr>
              <td colspan="3" class="text-center px-4 py-4 text-gray-500">No sessions added yet.</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- Edit Session Modal -->
  <div id="editModal" class="hidden fixed inset-0 flex items-center justify-center bg-black bg-opacity-50">
    <div class="bg-white rounded-2xl shadow-lg p-6 w-full max-w-md">
      <h2 class="text-xl font-bold text-gray-800 mb-4">Edit Session</h2>
      <form method="post" class="space-y-4">
        <input type="hidden" name="session_id" id="edit_session_id">
        <div>
          <label class="block text-gray-700 mb-1">Session Year</label>
          <input 
            type="text" 
            name="session_year" 
            id="edit_session_year" 
            class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-yellow-500 outline-none"
          >
        </div>
        <div class="flex justify-end gap-3">
          <button 
            type="button" 
            onclick="closeEditModal()" 
            class="px-4 py-2 bg-gray-400 text-white rounded-lg hover:bg-gray-500">
            Cancel
          </button>
          <button 
            type="submit" 
            name="edit_session" 
            class="px-4 py-2 bg-yellow-600 text-white font-semibold rounded-lg hover:bg-yellow-700 transition">
            Update
          </button>
        </div>
      </form>
    </div>
  </div>




								</div>
								
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--end page wrapper -->
		<!--start overlay-->
		<div class="overlay toggle-icon"></div>
		<!--end overlay-->
		<!--Start Back To Top Button--> <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
		<!--End Back To Top Button-->
		<footer class="page-footer">
			<p class="mb-0">Copyright © 2024. All right reserved.</p>
		</footer>
	</div>
	<!--end wrapper-->
	<!--start switcher-->
	<?php include 'includes/customiser.php'; ?>

	<!--end switcher-->
	<!-- Bootstrap JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<script src="assets/js/jquery.min.js"></script>
	<script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--app JS-->
	<script src="assets/js/app.js"></script>
</body>


</html>

