<?php 

include('includes/config.php');


?>


<?php
include('includes/user_data.php');

?>
<?php


$teacher_id = $_SESSION['teacher_id'] ?? null;
if (!$teacher_id) {
    echo "You must be logged in as a teacher.";
    exit;
}

// Load dropdown data
$sessions = $dbh->query("SELECT id, session_year FROM sessions ORDER BY session_year DESC")->fetchAll(PDO::FETCH_ASSOC);
$terms    = $dbh->query("SELECT id, term_name FROM terms ORDER BY id")->fetchAll(PDO::FETCH_ASSOC);
$classes  = $dbh->query("SELECT id, name FROM classes ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
$subjects = $dbh->query("SELECT id, name FROM Subjects ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
?>


<!doctype html>
<html lang="en">


<!-- Mirrored from codervent.com/rocker/demo/vertical/user-profile.html by HTTrack Website Copier/3.x [XR&CO'2014], Fri, 26 Aug 2022 06:47:36 GMT -->
<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!--favicon-->
	<link rel="icon" href="assets/images/favicon-32x32.png" type="image/png" />
	<!--plugins-->
	<link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
	<link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
	<link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
	<!-- loader-->
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
	<!-- Bootstrap CSS -->
	<link href="assets/css/bootstrap.min.css" rel="stylesheet">
	<link href="assets/css/bootstrap-extended.css" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&amp;display=swap" rel="stylesheet">
	<link href="assets/css/app.css" rel="stylesheet">
	<link href="assets/css/icons.css" rel="stylesheet">
	<!-- Theme Style CSS -->
	<link rel="stylesheet" href="assets/css/dark-theme.css" />
	<link rel="stylesheet" href="assets/css/semi-dark.css" />
	<link rel="stylesheet" href="assets/css/header-colors.css" />

  <title>Manage Exams</title>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">

</head>

<body> 
	<!--wrapper-->
	<div class="wrapper">
		<!--sidebar wrapper -->
		<?php include 'includes/side.php'; ?>
		<!--end sidebar wrapper -->
		<!--start header -->
		<?php include 'includes/head.php'; ?>
		<!--end header -->
		<!--start page wrapper -->
		<div class="page-wrapper">
			<div class="page-content">
				<!--breadcrumb-->
				<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
					<div class="breadcrumb-title pe-3"></div>
					<div class="ps-3">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb mb-0 p-0">
								<li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
								</li>
								<li class="breadcrumb-item active" aria-current="page"></li>
							</ol>
						</nav>
					</div>
					
				</div>
				<!--end breadcrumb-->
				<div class="container">
					<div class="main-body">
						<div class="row">
						
							<div class="col-lg-12">
								<div class="card">
									<div class="card-body">

<?php


$teacher_id = $_SESSION['teacher_id'] ?? null;
if (!$teacher_id) {
    echo "Unauthorized.";
    exit;
}

// Load exams created by teacher
$stmt = $dbh->prepare("SELECT e.*, s.session_year, t.term_name, c.name AS class_name, sub.name AS subject_name 
    FROM exams e
    JOIN sessions s ON e.session_id = s.id
    JOIN terms t ON e.term_id = t.id
    JOIN classes c ON e.class_id = c.id
    JOIN Subjects sub ON e.subject_id = sub.id
    WHERE e.teacher_id = :tid
    ORDER BY e.id DESC");
$stmt->execute([':tid'=>$teacher_id]);
$exams = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

  <h1 class="text-2xl font-bold mb-4">Manage My Exams</h1>

  <?php if(!$exams): ?>
    <p class="text-gray-500">No exams created yet.</p>
  <?php else: ?>
    <table class="min-w-full border text-sm bg-white shadow">
      <thead class="bg-gray-100">
        <tr>
          <th class="border px-2 py-1">#</th>
          <th class="border px-2 py-1">Class</th>
          <th class="border px-2 py-1">title and Subject</th>
          <th class="border px-2 py-1">Term</th>
          <th class="border px-2 py-1">Session</th>
          <!--<th class="border px-2 py-1">Type</th>-->
          <th class="border px-2 py-1">Duration</th>
          <th class="border px-2 py-1">Status</th>
          <th class="border px-2 py-1">Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($exams as $i=>$exam): ?>
          <tr id="erow<?=$exam['id']?>">
            <td class="border px-2 py-1"><?=$i+1?></td>
            <td class="border px-2 py-1"><?=$exam['class_name']?></td>
            <td class="border px-2 py-1"><?=$exam['title']?> <?=$exam['subject_name']?></td>
            <td class="border px-2 py-1"><?=$exam['term_name']?></td>
            <td class="border px-2 py-1"><?=$exam['session_year']?></td>
            <!--<td class="border px-2 py-1"><?=$exam['type']?></td>-->
            <td class="border px-2 py-1"><?=$exam['duration_minutes']?> min</td>
            <td class="border px-2 py-1">
              <span class="statusLabel px-2 py-1 rounded text-xs <?=($exam['status']=='published'?'bg-green-200 text-green-800':'bg-yellow-200 text-yellow-800')?>"><?=$exam['status']?></span>
            </td>
            <td class="border px-2 py-1 space-x-1">
              <button class="px-2 py-1 bg-blue-500 text-white rounded text-xs editBtn" style = "display:none;" 
                      data-id="<?=$exam['id']?>" 
                      data-class="<?=$exam['class_id']?>" 
                      data-subject="<?=$exam['subject_id']?>" 
                      data-term="<?=$exam['term_id']?>" 
                      data-session="<?=$exam['session_id']?>" >edit</button>
                       
                      
              <button class="px-2 py-1 bg-purple-500 text-white rounded text-xs toggleBtn" data-id="<?=$exam['id']?>" data-status="<?=$exam['status']?>">Toggle</button>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  <?php endif; ?>

  <!-- Edit Exam Modal -->
  <div id="editModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center">
    <div class="bg-white p-6 rounded w-full max-w-lg">
      <h2 class="text-xl font-bold mb-4">Edit Exam</h2>
      <form id="editExamForm">
        <input type="hidden" id="edit_id" name="id">
        <div class="mb-3">
          <label class="block">Duration (minutes)</label>
          <input type="number" name="set_time_minutes" id="edit_time" class="w-full border p-2 rounded" required>
        </div>
       
        <!-- If you want, you can also allow changing session, term, class, subject -->
        <div class="flex justify-end space-x-2">
          <button type="button" id="closeModal" class="px-3 py-1 rounded bg-gray-400 text-white">Cancel</button>
          <button type="submit" class="px-3 py-1 rounded bg-green-600 text-white">Save</button>
        </div>
      </form>
    </div>
  </div>

<script>
$(".editBtn").click(function(){
  $("#edit_id").val($(this).data("id"));
  $("#edit_type").val($(this).data("type"));
  $("#edit_time").val($(this).data("time"));
  $("#editModal").removeClass("hidden").addClass("flex");
});
$("#closeModal").click(function(){
  $("#editModal").addClass("hidden").removeClass("flex");
});

// Save edits
$("#editExamForm").submit(function(e){
  e.preventDefault();
  $.post("update_exam.php", $(this).serialize(), function(res){
    alert(res);
    if(res.includes("updated")){
      location.reload();
    }
  });
});

// Toggle publish/draft
$(".toggleBtn").click(function(){
  let id = $(this).data("id");
  let status = $(this).data("status");
  $.post("toggle_exam_status.php",{id:id,status:status},function(res){
    alert(res);
    if(res.includes("toggled")) location.reload();
  });
});
</script>



							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--end page wrapper -->
		<!--start overlay-->
		<div class="overlay toggle-icon"></div>
		<!--end overlay-->
		<!--Start Back To Top Button--> <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
		<!--End Back To Top Button-->
		<footer class="page-footer">
			<p class="mb-0">Copyright © 2025. All right reserved.</p>
		</footer>
	</div>
	<!--end wrapper-->
	<!--start switcher-->
	<?php include 'includes/customiser.php'; ?>

	<!--end switcher-->
	<!-- Bootstrap JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<script src="assets/js/jquery.min.js"></script>
	<script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--app JS-->
	<script src="assets/js/app.js"></script>
</body>


</html>
