<?php 

include('includes/config.php');


?>


<?php
include('includes/user_data.php');

?>
<?php


$teacher_id = $_SESSION['teacher_id'] ?? null;
if (!$teacher_id) {
    echo "You must be logged in as a teacher.";
    exit;
}

// Load dropdown data
$sessions = $dbh->query("SELECT id, session_year FROM sessions ORDER BY session_year DESC")->fetchAll(PDO::FETCH_ASSOC);
$terms    = $dbh->query("SELECT id, term_name FROM terms ORDER BY id")->fetchAll(PDO::FETCH_ASSOC);
$classes  = $dbh->query("SELECT id, name FROM classes ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
$subjects = $dbh->query("SELECT id, name FROM Subjects ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
?>


<!doctype html>
<html lang="en">


<!-- Mirrored from codervent.com/rocker/demo/vertical/user-profile.html by HTTrack Website Copier/3.x [XR&CO'2014], Fri, 26 Aug 2022 06:47:36 GMT -->
<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!--favicon-->
	<link rel="icon" href="assets/images/favicon-32x32.png" type="image/png" />
	<!--plugins-->
	<link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
	<link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
	<link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
	<!-- loader-->
	<link href="assets/css/pace.min.css" rel="stylesheet" />
	<script src="assets/js/pace.min.js"></script>
	<!-- Bootstrap CSS -->
	<link href="assets/css/bootstrap.min.css" rel="stylesheet">
	<link href="assets/css/bootstrap-extended.css" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&amp;display=swap" rel="stylesheet">
	<link href="assets/css/app.css" rel="stylesheet">
	<link href="assets/css/icons.css" rel="stylesheet">
	<!-- Theme Style CSS -->
	<link rel="stylesheet" href="assets/css/dark-theme.css" />
	<link rel="stylesheet" href="assets/css/semi-dark.css" />
	<link rel="stylesheet" href="assets/css/header-colors.css" />

<title>Submissions</title><script src="https://cdn.tailwindcss.com"></script></head>

<body> 
	<!--wrapper-->
	<div class="wrapper">
		<!--sidebar wrapper -->
		<?php include 'includes/side.php'; ?>
		<!--end sidebar wrapper -->
		<!--start header -->
		<?php include 'includes/head.php'; ?>
		<!--end header -->
		<!--start page wrapper -->
		<div class="page-wrapper">
			<div class="page-content">
				<!--breadcrumb-->
				<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
					<div class="breadcrumb-title pe-3"></div>
					<div class="ps-3">
						<nav aria-label="breadcrumb">
							<ol class="breadcrumb mb-0 p-0">
								<li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
								</li>
								<li class="breadcrumb-item active" aria-current="page"></li>
							</ol>
						</nav>
					</div>
					
				</div>
				<!--end breadcrumb-->
				<div class="container">
					<div class="main-body">
						<div class="row">
						
							<div class="col-lg-12">
								<div class="card">
									<div class="card-body">
<?php
// teacher_view_submissions.php
require 'config.php';
session_start();
if (!isset($_SESSION['teacher_id'])) { echo "Login as teacher."; exit; }
$teacher_id = $_SESSION['teacher_id'];
$exam_id = (int)($_GET['exam_id'] ?? 0);
if (!$exam_id) { echo "No exam specified"; exit; }

// ensure exam belongs to teacher
$stmt = $dbh->prepare("SELECT * FROM exams WHERE id = :id AND teacher_id = :tid LIMIT 1");
$stmt->execute([':id'=>$exam_id, ':tid'=>$teacher_id]);
$exam = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$exam) { echo "Not authorized"; exit; }

// fetch attempts
$stmt = $dbh->prepare("SELECT a.*, st.name as student_name FROM exam_attempts a JOIN students st ON st.id = a.student_id WHERE a.exam_id = :eid ORDER BY a.started_at DESC");
$stmt->execute([':eid'=>$exam_id]);
$attempts = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

  <div class="max-w-6xl mx-auto bg-white p-6 rounded">
    <h1 class="text-xl mb-4">Submissions for <?=htmlspecialchars($exam['title'])?></h1>
    <?php if(!$attempts): ?><div>No submissions yet.</div><?php else: ?>
      <table class="min-w-full">
        <thead><tr><th>Student</th><th>Started</th><th>Submitted</th><th>Score</th><th>Action</th></tr></thead>
        <tbody>
        <?php foreach($attempts as $a): ?>
          <tr class="border-t">
            <td class="p-2"><?=htmlspecialchars($a['student_name'])?></td>
            <td class="p-2"><?=htmlspecialchars($a['started_at'])?></td>
            <td class="p-2"><?=htmlspecialchars($a['submitted_at'] ?? '-')?></td>
            <td class="p-2"><?=htmlspecialchars($a['score'] ?? '-')?></td>
            <td class="p-2"><a href="teacher_view_attempt.php?attempt_id=<?=$a['id']?>" class="bg-blue-600 text-white px-2 py-1 rounded">View</a></td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    <?php endif; ?>
  </div>




					</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!--end page wrapper -->
		<!--start overlay-->
		<div class="overlay toggle-icon"></div>
		<!--end overlay-->
		<!--Start Back To Top Button--> <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
		<!--End Back To Top Button-->
		<footer class="page-footer">
			<p class="mb-0">Copyright © 2025. All right reserved.</p>
		</footer>
	</div>
	<!--end wrapper-->
	<!--start switcher-->
	<?php include 'includes/customiser.php'; ?>

	<!--end switcher-->
	<!-- Bootstrap JS -->
	<script src="assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<script src="assets/js/jquery.min.js"></script>
	<script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--app JS-->
	<script src="assets/js/app.js"></script>
</body>


</html>

